package aln.SpawnCommands;

import net.minecraft.entity.player.EntityPlayer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;

public class ForgeHooks {
  
  @SubscribeEvent
  public void LivingDeathEvent(net.minecraftforge.event.entity.living.LivingDeathEvent event) {
    if ( event.entity.worldObj.isRemote ) { return; }
    if (!(event.entity instanceof EntityPlayer)) { return; } // if not a player leave
    EntityPlayer player = (EntityPlayer) event.entity;
    
    // get player's location at this DEATH
    double  px = Math.round(player.posX - .5); // player's coordinates rounded down
    double  py = Math.round(player.posY - .5);
    double  pz = Math.round(player.posZ - .5);
    Float   pyaw = player.rotationYaw;
    Float   ppitch = player.rotationPitch;
    //Integer pdim = player.worldObj.provider.getDimensionId(); // mc1.8
    Integer pdim = player.worldObj.provider.dimensionId; // mc1.7.10
    String newGoBackLocation = px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ pdim;
    
    // write the location of the next go back command
    //if (! Do.StringToFile( SpawnCommands.configBasePath + player.getName() + "/_" + player.getName() +"_GoBackLocation", newGoBackLocation ) ) // mc1.8 
    if (! Do.StringToFile( SpawnCommands.configBasePath + player.getGameProfile().getName() + "/_" + player.getGameProfile().getName() +"_GoBackLocation", newGoBackLocation ) ) // mc1.7.10 
    { Do.Err(player,"CommandSpawn: Could not create the file that stores the location to go back to."); return; }
    
    return;
  }
  
}
